typedef void (*__usartRs232Function)();

volatile unsigned char __usartRs232Data = 0;
volatile bool __usartRs232Jump = false;
volatile __usartRs232Function __usartRs232FunctionJump = 0;

#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
_INTERRUPT_JUMP (_USART_RX)
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
_INTERRUPT_JUMP (_USART0_RX)
#endif
{
	__usartRs232Data = Core::readUsart (8);
	
	if (__usartRs232Jump == true)
	{
		__usartRs232FunctionJump();
	}
}

void UsartRs232::start (void functionJump())
{
	if (functionJump != 0)
	{
		__usartRs232Jump = true;
		__usartRs232FunctionJump = functionJump;
	}
	
	Core::startUsart (9600);
	Core::startGlobalInterrupt();
}

void UsartRs232::receive()
{
	data = __usartRs232Data;
}

void UsartRs232::transmit (const unsigned char DATA)
{
	Core::writeUsart (DATA, 8);
}

void UsartRs232::stop()
{
	Core::stopUsart();
	
	__usartRs232FunctionJump = 0;
	__usartRs232Jump = false;
}
