typedef void (*__usartNetworkFunction)();

volatile unsigned long __usartNetworkId = 0;
volatile unsigned char __usartNetworkAddress = 0;
volatile signed long __usartNetworkTemporaryData = 0;
volatile signed long __usartNetworkData [64] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __usartNetworkJump = false;
volatile __usartNetworkFunction __usartNetworkFunctionJump = 0;

#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
_INTERRUPT_JUMP (_USART_RX)
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
_INTERRUPT_JUMP (_USART0_RX)
#endif
{
	if (Core::readUsart (8) == 0b01010101 && (unsigned long)(Core::readUsart (32)) == __usartNetworkId)
	{
		__usartNetworkAddress = Core::readUsart (8);
		__usartNetworkTemporaryData = Core::readUsart (32);
		
		if ((unsigned long)(Core::readUsart (32) == Core::crc32 (__usartNetworkTemporaryData))
		{
			__usartNetworkData [__usartNetworkAddress] = __usartNetworkTemporaryData;
			
			if (__usartNetworkJump == true)
			{
				__usartNetworkFunctionJump();
			}
		}
	}
}

UsartNetwork::UsartNetwork (const unsigned char ADDRESS)
{
	_address = ADDRESS - 1;
}

void UsartNetwork::start (void functionJump(), const unsigned long ID)
{
	if (functionJump != 0)
	{
		__usartNetworkJump = true;
		__usartNetworkFunctionJump = functionJump;
	}
	
	__usartNetworkId = ID;
	
	Core::startUsart (2000000);
	Core::startGlobalInterrupt();
}

void UsartNetwork::receive()
{
	data = __usartNetworkData [_address];
}

void UsartNetwork::transmit (const signed long DATA)
{
	Core::writeUsart (0b01010101, 8);
	Core::writeUsart (__usartNetworkId, 32);
	Core::writeUsart (_address, 8);
	Core::writeUsart (DATA, 32);
	Core::writeUsart (Core::crc32 (DATA), 32);
}

void UsartNetwork::stop()
{
	Core::stopUsart();
	
	__usartNetworkFunctionJump = 0;
	__usartNetworkJump = false;
}
