typedef void (*__usartMidiFunction)();

volatile unsigned char __usartMidiStatus = 0;
volatile unsigned char __usartMidiData = 0;
volatile unsigned char __usartMidiDescription = 0;
volatile bool __usartMidiJump = false;
volatile __usartMidiFunction __usartMidiFunctionJump = 0;

#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
_INTERRUPT_JUMP (_USART_RX)
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
_INTERRUPT_JUMP (_USART0_RX)
#endif
{
	__usartMidiStatus = Core::readUsart (8);
	__usartMidiData = Core::readUsart (8);
	__usartMidiDescription = Core::readUsart (8);
	
	if (__usartMidiJump == true)
	{
		__usartMidiFunctionJump();
	}
}

void UsartMidi::start (void functionJump())
{
	if (functionJump != 0)
	{
		__usartMidiJump = true;
		__usartMidiFunctionJump = functionJump;
	}
	
	Core::startUsart (31250);
	Core::startGlobalInterrupt();
}

void UsartMidi::receive()
{
	status = __usartMidiStatus;
	data = __usartMidiData;
	description = __usartMidiDescription;
}

void UsartMidi::transmit (const unsigned char STATUS, const unsigned char DATA, const unsigned char DESCRIPTION)
{
	Core::writeUsart (STATUS, 8);
	Core::writeUsart (DATA, 8);
	Core::writeUsart (DESCRIPTION, 8);
}

void UsartMidi::stop()
{
	Core::stopUsart();
	
	__usartMidiFunctionJump = 0;
	__usartMidiJump = false;
}
