TwiMpu6050::TwiMpu6050 (const unsigned char DEVICE)
{
	unsigned char iterationDevice = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (iterationDevice = 0; iterationDevice < 128 && foundDevice == false; iterationDevice++)
		{
			if (Core::scanTwi (iterationDevice) == true)
			{
				_device = iterationDevice;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while ((Core::readTwi (_device, 0x75, 8) & 0b01111110) == 0b00000000)
	{
	}
	
	while ((Core::readTwi (_device, 0x6b, 8) & 0b11101111) != 0b00000001)
	{
		Core::writeTwi (_device, 0x6b, 0b00000001, 8);
	}
	
	while ((Core::readTwi (_device, 0x1c, 8) & 0b11111000) != 0b00011000)
	{
		Core::writeTwi (_device, 0x1c, 0b00011000, 8);
	}
	
	while ((Core::readTwi (_device, 0x1b, 8) & 0b11111000) != 0b00011000)
	{
		Core::writeTwi (_device, 0x1b, 0b00011000, 8);
	}
}

void TwiMpu6050::read()
{
	tx = (float)(Core::readTwi (_device, 0x3b, 16)) / 2048.0;
	ty = (float)(Core::readTwi (_device, 0x3d, 16)) / 2048.0;
	tz = (float)(Core::readTwi (_device, 0x3f, 16)) / 2048.0;
	
	rx = (float)(Core::readTwi (_device, 0x43, 16)) / 16.4;
	ry = (float)(Core::readTwi (_device, 0x45, 16)) / 16.4;
	rz = (float)(Core::readTwi (_device, 0x47, 16)) / 16.4;
	
	temperature = ((float)(Core::readTwi (_device, 0x41, 16)) / 340.0) + 36.53;
}

void TwiMpu6050::readTranslation()
{
	tx = (float)(Core::readTwi (_device, 0x3b, 16)) / 2048.0;
	ty = (float)(Core::readTwi (_device, 0x3d, 16)) / 2048.0;
	tz = (float)(Core::readTwi (_device, 0x3f, 16)) / 2048.0;
}

void TwiMpu6050::readRotation()
{
	rx = (float)(Core::readTwi (_device, 0x43, 16)) / 16.4;
	ry = (float)(Core::readTwi (_device, 0x45, 16)) / 16.4;
	rz = (float)(Core::readTwi (_device, 0x47, 16)) / 16.4;
}

void TwiMpu6050::readTemperature()
{
	temperature = ((float)(Core::readTwi (_device, 0x41, 16)) / 340.0) + 36.53;
}
