TwiBno055::TwiBno055 (const unsigned char DEVICE)
{
	unsigned char iterationDevice = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (iterationDevice = 0; iterationDevice < 128 && foundDevice == false; iterationDevice++)
		{
			if (Core::scanTwi (iterationDevice) == true)
			{
				_device = iterationDevice;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while ((Core::readTwi (_device, 0x3f, 8) & 0b00100000) != 0b00100000)
	{
		Core::writeTwi (_device, 0x3f, 0b00100000, 8);
	}
	
	while ((Core::readTwi (_device, 0x3f, 8) & 0b00000001) != 0b00000001)
	{
		Core::writeTwi (_device, 0x3f, 0b00000001, 8);
	}
	
	while ((Core::readTwi (_device, 0x36, 8) & 0b00001111) != 0b00001111)
	{
	}
	
	while (Core::readTwi (_device, 0x39, 8) != 0b00000000)
	{
	}
	
	while ((Core::readTwi (_device, 0x41, 8) & 0b00111111) != 0b00100001)
	{
		Core::writeTwi (_device, 0x41, 0b00100001, 8);
	}
	
	while ((Core::readTwi (_device, 0x42, 8) & 0b00000111) != 0b00000100)
	{
		Core::writeTwi (_device, 0x42, 0b00000100, 8);
	}
	
	while ((Core::readTwi (_device, 0x3d, 8) & 0b00001111) != 0b00001100)
	{
		Core::writeTwi (_device, 0x3d, 0b00001100, 8);
	}
	
	while (Core::readTwi (_device, 0x39, 8) != 0b00000101)
	{
	}
}

void TwiBno055::read()
{
	const signed int GZ_RAW = Core::readTwi (_device, 0x32, -16);
	const signed int PITCH_RAW = -Core::readTwi (_device, 0x1e, -16);
	const signed int ROLL_RAW = -Core::readTwi (_device, 0x1c, -16);
	const signed int YAW_RAW = -Core::readTwi (_device, 0x1a, -16);
	
	gx = (float)(Core::readTwi (_device, 0x2e, -16)) / 100.0;
	gy = (float)(Core::readTwi (_device, 0x30, -16)) / 100.0;
	gz = (float)(GZ_RAW) / 100.0;
	
	tx = (float)(Core::readTwi (_device, 0x28, -16)) / 100.0;
	ty = (float)(Core::readTwi (_device, 0x2a, -16)) / 100.0;
	tz = (float)(Core::readTwi (_device, 0x2c, -16)) / 100.0;
	
	rx = (float)(Core::readTwi (_device, 0x14, -16)) / 16.0;
	ry = (float)(Core::readTwi (_device, 0x16, -16)) / 16.0;
	rz = (float)(Core::readTwi (_device, 0x18, -16)) / 16.0;
	
	qw = Core::readTwi (_device, 0x20, -16);
	qx = Core::readTwi (_device, 0x22, -16);
	qy = Core::readTwi (_device, 0x24, -16);
	qz = Core::readTwi (_device, 0x26, -16);
	
	mx = (float)(Core::readTwi (_device, 0x0e, -16)) / 16.0;
	my = (float)(Core::readTwi (_device, 0x10, -16)) / 16.0;
	mz = (float)(Core::readTwi (_device, 0x12, -16)) / 16.0;
	
	pitch = (float)(PITCH_RAW) / 16.0;
	
	if (GZ_RAW < 0)
	{
		if (PITCH_RAW < 0)
		{
			pitchAero = -180.0 - ((float)(PITCH_RAW) / 16.0);
		}
		else
		{
			pitchAero = 180.0 - ((float)(PITCH_RAW) / 16.0);
		}
	}
	else
	{
		pitchAero = (float)(PITCH_RAW) / 16.0;
	}
	
	if (GZ_RAW < 0)
	{
		if (ROLL_RAW < 0)
		{
			roll = -180.0 - ((float)(ROLL_RAW) / 16.0);
		}
		else
		{
			roll = 180.0 - ((float)(ROLL_RAW) / 16.0);
		}
	}
	else
	{
		roll = (float)(ROLL_RAW) / 16.0;
	}
	
	rollAero = (float)(ROLL_RAW) / 16.0;
	
	if (YAW_RAW < -2880)
	{
		yaw = 360.0 + ((float)(YAW_RAW) / 16.0);
	}
	else
	{
		yaw = (float)(YAW_RAW) / 16.0;
	}
	
	temperature = Core::readTwi (_device, 0x34, 8);
	
	if (nord == false && (Core::readTwi (_device, 0x35, 8) & 0b00000011) == 0b00000011)
	{
		nord = true;
	}
}

void TwiBno055::readGravity()
{
	gx = (float)(Core::readTwi (_device, 0x2e, -16)) / 100.0;
	gy = (float)(Core::readTwi (_device, 0x30, -16)) / 100.0;
	gz = (float)(Core::readTwi (_device, 0x32, -16)) / 100.0;
}

void TwiBno055::readTranslation()
{
	tx = (float)(Core::readTwi (_device, 0x28, -16)) / 100.0;
	ty = (float)(Core::readTwi (_device, 0x2a, -16)) / 100.0;
	tz = (float)(Core::readTwi (_device, 0x2c, -16)) / 100.0;
}

void TwiBno055::readRotation()
{
	rx = (float)(Core::readTwi (_device, 0x14, -16)) / 16.0;
	ry = (float)(Core::readTwi (_device, 0x16, -16)) / 16.0;
	rz = (float)(Core::readTwi (_device, 0x18, -16)) / 16.0;
}

void TwiBno055::readQuaternion()
{
	qw = Core::readTwi (_device, 0x20, -16);
	qx = Core::readTwi (_device, 0x22, -16);
	qy = Core::readTwi (_device, 0x24, -16);
	qz = Core::readTwi (_device, 0x26, -16);
}

void TwiBno055::readMagnetism()
{
	mx = (float)(Core::readTwi (_device, 0x0e, -16)) / 16.0;
	my = (float)(Core::readTwi (_device, 0x10, -16)) / 16.0;
	mz = (float)(Core::readTwi (_device, 0x12, -16)) / 16.0;
}

void TwiBno055::readHorizon()
{
	const signed int GZ_RAW = Core::readTwi (_device, 0x32, -16);
	const signed int PITCH_RAW = -Core::readTwi (_device, 0x1e, -16);
	const signed int ROLL_RAW = -Core::readTwi (_device, 0x1c, -16);
	const signed int YAW_RAW = -Core::readTwi (_device, 0x1a, -16);
	
	pitch = (float)(PITCH_RAW) / 16.0;
	
	if (GZ_RAW < 0)
	{
		if (PITCH_RAW < 0)
		{
			pitchAero = -180.0 - ((float)(PITCH_RAW) / 16.0);
		}
		else
		{
			pitchAero = 180.0 - ((float)(PITCH_RAW) / 16.0);
		}
	}
	else
	{
		pitchAero = (float)(PITCH_RAW) / 16.0;
	}
	
	if (GZ_RAW < 0)
	{
		if (ROLL_RAW < 0)
		{
			roll = -180.0 - ((float)(ROLL_RAW) / 16.0);
		}
		else
		{
			roll = 180.0 - ((float)(ROLL_RAW) / 16.0);
		}
	}
	else
	{
		roll = (float)(ROLL_RAW) / 16.0;
	}
	
	rollAero = (float)(ROLL_RAW) / 16.0;
	
	if (YAW_RAW < -2880)
	{
		yaw = 360.0 + ((float)(YAW_RAW) / 16.0);
	}
	else
	{
		yaw = (float)(YAW_RAW) / 16.0;
	}
	
	if (nord == false && (Core::readTwi (_device, 0x35, 8) & 0b00000011) == 0b00000011)
	{
		nord = true;
	}
}

void TwiBno055::readTemperature()
{
	temperature = Core::readTwi (_device, 0x34, 8);
}
