TwiBme280::TwiBme280 (const unsigned char DEVICE)
{
	unsigned char iterationDevice = 0;
	bool foundDevice = false;
	unsigned char e5 = 0;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (iterationDevice = 0; iterationDevice < 128 && foundDevice == false; iterationDevice++)
		{
			if (Core::scanTwi (iterationDevice) == true)
			{
				_device = iterationDevice;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while (Core::readTwi (_device, 0xd0, 8) == 0b00000000)
	{
	}
	
	while ((Core::readTwi (_device, 0xf2, 8) & 0b00000111) != 0b00000001)
	{
		Core::writeTwi (_device, 0xf2, 0b00000001, 8);
	}
	
	while (Core::readTwi (_device, 0xf4, 8) != 0b00100111)
	{
		Core::writeTwi (_device, 0xf4, 0b00100111, 8);
	}
	
	e5 = Core::readTwi (_device, 0xe5, 8);
	
	_digT1 = Core::readTwi (_device, 0x88, -16);
	_digT2 = Core::readTwi (_device, 0x8a, -16);
	_digT3 = Core::readTwi (_device, 0x8c, -16);
	_digP1 = Core::readTwi (_device, 0x8e, -16);
	_digP2 = Core::readTwi (_device, 0x90, -16);
	_digP3 = Core::readTwi (_device, 0x92, -16);
	_digP4 = Core::readTwi (_device, 0x94, -16);
	_digP5 = Core::readTwi (_device, 0x96, -16);
	_digP6 = Core::readTwi (_device, 0x98, -16);
	_digP7 = Core::readTwi (_device, 0x9a, -16);
	_digP8 = Core::readTwi (_device, 0x9c, -16);
	_digP9 = Core::readTwi (_device, 0x9e, -16);
	_digH1 = Core::readTwi (_device, 0xa1, 8);
	_digH2 = Core::readTwi (_device, 0xe1, -16);
	_digH3 = Core::readTwi (_device, 0xe3, 8);
	_digH4 = (signed int)(Core::readTwi (_device, 0xe4, 8)) << 4 | (e5 & 0b00001111);
	_digH5 = (signed int)(Core::readTwi (_device, 0xe6, 8)) << 4 | (e5 & 0b11110000) >> 4;
	_digH6 = Core::readTwi (_device, 0xe7, 8);
}

void TwiBme280::read()
{
	const unsigned int HUMIDITY_RAW = Core::readTwi (_device, 0xfd, 16);
	const unsigned long PRESSURE_RAW = ((unsigned long)(Core::readTwi (_device, 0xf7, 16)) << 16) >> 12;
	const unsigned long TEMPERATURE_RAW = ((unsigned long)(Core::readTwi (_device, 0xfa, 16)) << 16) >> 12;
	float mix1 = 0;
	float mix2 = 0;
	float mix3 = 0;
	float mix4 = 0;
	float mix5 = 0;
	float mix6 = 0;
	float mix7 = 0;
	float mix8 = 0;
	
	mix1 = ((float)(TEMPERATURE_RAW) / 131072.0) - ((float)(_digT1) / 8192.0);
	mix2 = ((((float)(TEMPERATURE_RAW) / 16384.0) - ((float)(_digT1) / 1024.0)) * (float)(_digT2)) + ((mix1 * mix1) * (float)(_digT3));
	mix3 = mix2 - 76800.0;
	mix4 = ((float)(HUMIDITY_RAW) - (((float)(_digH4) * 64.0) + (((float)(_digH5) / 16384.0) * mix3))) * (((float)(_digH2) / 65536.0) * (1.0 + ((((float)(_digH6) / 67108864.0) * mix3) * (1.0 + (((float)(_digH3) / 67108864.0) * mix3)))));
	mix5 = mix4 * (1.0 - (((float)(_digH1) * mix4) / 524288.0));
	mix6 = (mix2 / 2.0) - 64000.0;
	mix7 = (1.0 + (((((((float)(_digP3) * mix6) * mix6) / 524288.0) + ((float)(_digP2) * mix6)) / 524288.0) / 32768.0)) * (float)(_digP1);
	
	if (mix5 < 0)
	{
		mix5 = 0;
	}
	else if (mix5 > 100)
	{
		mix5 = 100;
	}
	
	humidity = mix5;
	
	if (mix7 != 0)
	{
		mix8 = (((1048576.0 - (float)(PRESSURE_RAW)) - (((((((mix6 * mix6) * (float)(_digP6)) / 32768.0) + ((mix6 * (float)(_digP5)) * 2.0)) / 4.0) + ((float)(_digP4) * 65536.0)) / 4096.0)) * 6250.0) / mix7;
		pressure = mix8 + ((((((float)(_digP9) * mix8) * mix8) / 2147483648.0) + (((mix8 * (float)(_digP8)) / 32768.0) + (float)(_digP7))) / 16.0);
	}
	
	temperature = mix2 / 5120.0;
}
