TwiAmg88::TwiAmg88 (const unsigned char DEVICE)
{
	unsigned char iterationDevice = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	if (DEVICE == 0)
	{
		for (iterationDevice = 0; iterationDevice < 128 && foundDevice == false; iterationDevice++)
		{
			if (Core::scanTwi (iterationDevice) == true)
			{
				_device = iterationDevice;
				foundDevice = true;
			}
		}
	}
	else
	{
		_device = DEVICE;
	}
	
	while ((Core::readTwi (_device, 0x02, 8) & 0b00000001) != 0b00000001)
	{
		Core::writeTwi (_device, 0x02, 0b00000001, 8);
	}
	
	while ((Core::readTwi (_device, 0x02, 8) & 0b00000001) != 0b00000000)
	{
		Core::writeTwi (_device, 0x02, 0b00000000, 8);
	}
}

void TwiAmg88::read()
{
	unsigned char iterationAddress = 0;
	unsigned int temperatureRaw = 0;
	
	for (iterationAddress = 0; iterationAddress < 64; iterationAddress++)
	{
		temperatureRaw = Core::readTwi (_device, 128 + (iterationAddress * 2), -16);
		temperature [iterationAddress] = (float)((temperatureRaw & 0b0000100000000000) << 4 | (temperatureRaw & 0b0000011111111111)) / 4.0;
	}
}
