unsigned char Tool::digitToByte (const unsigned char DIGIT, const bool COMMA)
{
	return Core::digitToByte (DIGIT, COMMA);
}

unsigned char Tool::characterToByte (const char *CHARACTER)
{
	unsigned char byte = 0;
	
	if (CHARACTER [0] != 0b00101110 && CHARACTER [1] == 0b00101110)
	{
		byte = Core::characterToByte (CHARACTER [0]) | 0b10000000;
	}
	else
	{
		byte = Core::characterToByte (CHARACTER [0]);
	}
	
	return byte;
}

unsigned char Tool::scanTwi()
{
	unsigned char iterationDevice = 0;
	unsigned char device = 0;
	bool foundDevice = false;
	
	Core::startTwi();
	
	for (iterationDevice = 0; iterationDevice < 128 && foundDevice == false; iterationDevice++)
	{
		if (Core::scanTwi (iterationDevice) == true)
		{
			device = iterationDevice;
			foundDevice = true;
		}
	}
	
	return device;
}

signed int Tool::mcuSram()
{
	extern signed int __heap_start;
	extern signed int *__brkval;
	signed int *value = 0;
	
	return (signed int)(&value) - (__brkval == 0 ? (signed int)(&__heap_start) : (signed int)(__brkval));
}

void Tool::mcuSleep()
{
	Core::power (false);
}

void Tool::mcuWakeUp()
{
	Core::power (true);
}
