Timer::Timer()
{
	Core::startGlobalInterrupt();
	Core::startInterruptTimerCounter();
}

void Timer::start (const unsigned long long TIME_START)
{
	_timeStart = (Core::ms() - TIME_START) * 1000ull;
	_started = true;
}

void Timer::state()
{
	const unsigned long long US = Core::us() - _timeStart;
	
	if (_started == true)
	{
		s = US / 1000000ull;
		ms = US / 1000ull;
		us = US;
	}
}

void Timer::stop()
{
	_started = false;
}

void Timer::pause (const unsigned long long DURATION)
{
	const unsigned long long MS = Core::ms();
	
	Core::startGlobalInterrupt();
	Core::startInterruptTimerCounter();
	
	while (Core::ms() < MS + DURATION)
	{
	}
}
