#include "Core.h"

class SpiNrf24l01p
{
	private:
	static volatile unsigned char *_registerPin;
	static unsigned char _bytePort;
	static unsigned char _byteAdmux;
	static bool _antiCollision;
	static bool _started;
	static unsigned long _seed;
	unsigned char _address = 0;
	static signed long _data [64];
	static bool _received [64];
	
	public:
	signed long data = 0;
	bool received = false;
	SpiNrf24l01p (const unsigned char ADDRESS);
	static void start (const unsigned char PIN_SS, const unsigned char PIN_ANTI_COLLISION, const unsigned long RFID, const bool POWER);
	void receive();
	void transmit (const signed long DATA);
	void reset();
	static void stop();
};

volatile unsigned char *SpiNrf24l01p::_registerPin = 0;
unsigned char SpiNrf24l01p::_bytePort = 0;
unsigned char SpiNrf24l01p::_byteAdmux = 0;
bool SpiNrf24l01p::_antiCollision = true;
bool SpiNrf24l01p::_started = false;
unsigned char SpiNrf24l01p::_seed = 0;
signed long SpiNrf24l01p::_data [64] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
bool SpiNrf24l01p::_received [64] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

#include "SpiNrf24l01p.cpp"
