#include "Core.h"

class SpiMax7219
{
	private:
	unsigned char _pinSs = 0;
	volatile unsigned char *_registerPin = 0;
	unsigned char _bytePort = 0;
	unsigned char _device = 0;
	
	public:
	SpiMax7219 (const unsigned char PIN_SS);
	void brightness (const unsigned char BRIGHTNESS);
	void digit (const unsigned char DIGIT, const bool COMMA, const unsigned char POSITION);
	void integer (const signed long INTEGER, const unsigned char POSITION_MIN, const unsigned char POSITION_MAX, const bool SIDE);
	void decimal (const float DECIMAL, const unsigned char POSITION_MIN, const unsigned char POSITION_MAX, const unsigned char DIGIT_AFTER_COMMA, const bool SIDE);
	void character (const char *CHARACTER, const unsigned char POSITION);
	void word (const char *WORD);
	void byte (const unsigned char BYTE);
	void draw (const unsigned char DRAW, const unsigned char POSITION);
	void drawDevice (const unsigned char DRAW1, const unsigned char DRAW2, const unsigned char DRAW3, const unsigned char DRAW4, const unsigned char DRAW5, const unsigned char DRAW6, const unsigned char DRAW7, const unsigned char DRAW8);
	void dot (const unsigned char X, const unsigned char Y);
	void clearLine (const unsigned char LINE);
	void clearDevice();
};

#include "SpiMax7219.cpp"
