Spi25aa1024::Spi25aa1024 (const unsigned char PIN_SS)
{
	_registerPin = Core::pinToRegisterPin (PIN_SS);
	_bytePort = Core::pinToBytePort (PIN_SS);
	
	*_registerPin = _bytePort;
	Core::writeSpiPush (0b00000110, 8);
	*_registerPin = _bytePort;
}

signed long Spi25aa1024::read (const unsigned long ADDRESS, const signed char LENGTH)
{
	unsigned char iterationAddress = 0;
	unsigned char shift = 0;
	signed long data = 0;
	
	if (LENGTH < 0)
	{
		for (shift = -LENGTH; shift != 0; shift -= 8)
		{
			*_registerPin = _bytePort;
			Core::writeSpiPush (0b00000011, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 16, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 8, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1), 8);
			
			if (LENGTH == -8)
			{
				data |= (signed char)(Core::readSpiPush (8)) << (shift - 8);
			}
			else if (LENGTH == -16)
			{
				data |= (signed int)(Core::readSpiPush (8)) << (shift - 8);
			}
			else if (LENGTH == -32)
			{
				data |= (signed long)(Core::readSpiPush (8)) << (shift - 8);
			}
			
			*_registerPin = _bytePort;
			
			iterationAddress++;
		}
	}
	else
	{
		for (shift = LENGTH; shift != 0; shift -= 8)
		{
			*_registerPin = _bytePort;
			Core::writeSpiPush (0b00000011, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 16, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 8, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1), 8);
			
			if (LENGTH == 8)
			{
				data |= (unsigned char)(Core::readSpiPush (8)) << (shift - 8);
			}
			else if (LENGTH == 16)
			{
				data |= (unsigned int)(Core::readSpiPush (8)) << (shift - 8);
			}
			else if (LENGTH == 32)
			{
				data |= (unsigned long)(Core::readSpiPush (8)) << (shift - 8);
			}
			
			*_registerPin = _bytePort;
			
			iterationAddress++;
		}
	}
	
	return data;
}

void Spi25aa1024::write (const unsigned long ADDRESS, const signed long DATA, const signed char LENGTH)
{
	unsigned char iterationAddress = 0;
	unsigned char shift = 0;
	
	if (LENGTH < 0)
	{
		for (shift = -LENGTH; shift != 0; shift -= 8)
		{
			*_registerPin = _bytePort;
			Core::writeSpiPush (0b00000010, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 16, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 8, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1), 8);
			Core::writeSpiPush (DATA >> (shift - 8), 8);
			*_registerPin = _bytePort;
			
			iterationAddress++;
		}
	}
	else
	{
		for (shift = LENGTH; shift != 0; shift -= 8)
		{
			*_registerPin = _bytePort;
			Core::writeSpiPush (0b00000010, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 16, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1) >> 8, 8);
			Core::writeSpiPush (((ADDRESS + iterationAddress) - 1), 8);
			Core::writeSpiPush (DATA >> (shift - 8), 8);
			*_registerPin = _bytePort;
			
			iterationAddress++;
		}
	}
}

void Spi25aa1024::erase()
{
	*_registerPin = _bytePort;
	Core::writeSpiPush (0b11000111, 8);
	*_registerPin = _bytePort;
}
