volatile unsigned char *__soundWriteRegisterPort = 0;
volatile unsigned char *__soundWriteRegisterPin = 0;
volatile unsigned char __soundWriteBytePort = 0;
volatile unsigned int __soundWriteDuration = 0;
volatile bool __soundWritePlaying = false;
volatile bool __soundWritePlayingInfinite = false;
volatile bool __soundWritePlayingKey = false;
volatile unsigned int __soundWritePrescalerKey [64] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __soundWriteValueOcr2Key [64] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned int __soundWriteDurationKey [64] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __soundWriteBlankKey [64] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile unsigned char __soundWriteCountWhileKey = 0;
volatile unsigned char __soundWriteIterationWhileKey = 0;

_INTERRUPT_JUMP (_TIMER2_COMPA)
{
	if (__soundWritePlaying == true || __soundWritePlayingInfinite == true || __soundWritePlayingKey == true)
	{
		if (__soundWritePlaying == true || __soundWritePlayingInfinite == true || (__soundWritePlayingKey == true && __soundWriteBlankKey [__soundWriteIterationWhileKey] == false))
		{
			*__soundWriteRegisterPin = __soundWriteBytePort;
		}
		else
		{
			*__soundWriteRegisterPort &= ~__soundWriteBytePort;
		}
		
		if (__soundWritePlayingInfinite == false)
		{
			if (__soundWritePlaying == true)
			{
				if (__soundWriteDuration == 0)
				{
					__soundWritePlaying = false;
				}
				else
				{
					__soundWriteDuration--;
				}
			}
			else if (__soundWritePlayingKey == true)
			{
				if (__soundWriteDuration == 0)
				{
					__soundWriteIterationWhileKey++;
					
					if (__soundWriteIterationWhileKey == __soundWriteCountWhileKey)
					{
						__soundWritePlayingKey = false;
					}
					else
					{
						Core::prescalerTimerSound (__soundWritePrescalerKey [__soundWriteIterationWhileKey]);
						Core::outputCompareTimerSound (__soundWriteValueOcr2Key [__soundWriteIterationWhileKey]);
						__soundWriteDuration = __soundWriteDurationKey [__soundWriteIterationWhileKey];
					}
				}
				else
				{
					__soundWriteDuration--;
				}
			}
		}
	}
	else if (__soundWritePlaying == false || __soundWritePlayingInfinite == false || __soundWritePlayingKey == false)
	{
		Core::stopInterruptTimerSound();
		
		*__soundWriteRegisterPort &= ~__soundWriteBytePort;
		
		__soundWritePlaying = false;
		__soundWritePlayingInfinite = false;
		__soundWritePlayingKey = false;
	}
}

void SoundWrite::pin (const unsigned char PIN)
{
	__soundWriteRegisterPort = Core::pinToRegisterPort (PIN);
	__soundWriteRegisterPin = Core::pinToRegisterPin (PIN);
	__soundWriteBytePort = Core::pinToBytePort (PIN);
	
	*Core::pinToRegisterDdr (PIN) |= __soundWriteBytePort;
	
	Core::startGlobalInterrupt();
	Core::modeTimerSound();
}

void SoundWrite::play (const float FREQUENCY, const unsigned int DURATION)
{
	const unsigned int PRESCALER = Core::frequencyToPrescalerTimerSound (FREQUENCY);
	signed long value_ocr2 = 0;
	
	if (FREQUENCY != 0 && DURATION == 0)
	{
		__soundWritePlaying = false;
		__soundWritePlayingKey = false;
		
		Core::prescalerTimerSound (PRESCALER);
		
		value_ocr2 = Core::round (((16000000.0 / (FREQUENCY * 2.0)) / (float)(PRESCALER)) - 1.0);
		
		if (value_ocr2 >= 255)
		{
			Core::outputCompareTimerSound (255);
		}
		else if (value_ocr2 <= 0)
		{
			Core::outputCompareTimerSound (0);
		}
		else
		{
			Core::outputCompareTimerSound (value_ocr2);
		}
		
		__soundWritePlayingInfinite = true;
		
		Core::startInterruptTimerSound();
	}
	else if (__soundWritePlayingInfinite == false)
	{
		if (FREQUENCY != 0)
		{
			__soundWritePlayingKey = false;
			
			Core::prescalerTimerSound (PRESCALER);
			
			value_ocr2 = Core::round (((16000000.0 / (FREQUENCY * 2.0)) / (float)(PRESCALER)) - 1.0);
			
			if (value_ocr2 >= 255)
			{
				Core::outputCompareTimerSound (255);
				__soundWriteDuration = Core::round (((16000000.0 / (float)(PRESCALER)) / 255.0) * ((float)(DURATION) / 1000.0));
			}
			else if (value_ocr2 <= 0)
			{
				Core::outputCompareTimerSound (0);
				__soundWriteDuration = Core::round ((16000000.0 / (float)(PRESCALER)) * ((float)(DURATION) / 1000.0));
			}
			else
			{
				Core::outputCompareTimerSound (value_ocr2);
				__soundWriteDuration = Core::round ((FREQUENCY * 2.0) * ((float)(DURATION) / 1000.0));
			}
			
			__soundWritePlaying = true;
			
			Core::startInterruptTimerSound();
		}
		else if (_countAddKey > 0)
		{
			__soundWritePlaying = false;
			
			__soundWriteCountWhileKey = _countAddKey;
			_countAddKey = 0;
			__soundWriteIterationWhileKey = 0;
			
			Core::prescalerTimerSound (__soundWritePrescalerKey [0]);
			Core::outputCompareTimerSound (__soundWriteValueOcr2Key [0]);
			__soundWriteDuration = __soundWriteDurationKey [0];
			
			__soundWritePlayingKey = true;
			
			Core::startInterruptTimerSound();
		}
	}
}

void SoundWrite::add (const float FREQUENCY, const unsigned int DURATION)
{
	const unsigned int PRESCALER = Core::frequencyToPrescalerTimerSound (FREQUENCY);
	signed long value_ocr2 = 0;
	
	__soundWritePrescalerKey [_countAddKey] = PRESCALER;
	
	value_ocr2 = Core::round (((16000000.0 / (FREQUENCY * 2.0)) / (float)(PRESCALER)) - 1.0);
	
	if (value_ocr2 >= 255)
	{
		__soundWriteValueOcr2Key [_countAddKey] = 255;
		__soundWriteDurationKey [_countAddKey] = Core::round (((16000000.0 / (float)(PRESCALER)) / 255.0) * ((float)(DURATION) / 1000.0));
	}
	else if (value_ocr2 <= 0)
	{
		__soundWriteValueOcr2Key [_countAddKey] = 0;
		__soundWriteDurationKey [_countAddKey] = Core::round ((16000000.0 / (float)(PRESCALER)) * ((float)(DURATION) / 1000.0));
	}
	else
	{
		__soundWriteValueOcr2Key [_countAddKey] = value_ocr2;
		__soundWriteDurationKey [_countAddKey] = Core::round ((FREQUENCY * 2.0) * ((float)(DURATION) / 1000.0));
	}
	
	if (FREQUENCY == 0)
	{
		__soundWriteBlankKey [_countAddKey] = true;
	}
	else
	{
		__soundWriteBlankKey [_countAddKey] = false;
	}
	
	_countAddKey++;
}

void SoundWrite::modulate (const float FREQUENCY)
{
	const unsigned int PRESCALER = Core::frequencyToPrescalerTimerSound (FREQUENCY);
	signed long value_ocr2 = 0;
	
	Core::prescalerTimerSound (PRESCALER);
	
	value_ocr2 = Core::round (((16000000.0 / (FREQUENCY * 2.0)) / (float)(PRESCALER)) - 1.0);
	
	if (value_ocr2 >= 255)
	{
		Core::outputCompareTimerSound (255);
	}
	else if (value_ocr2 <= 0)
	{
		Core::outputCompareTimerSound (0);
	}
	else
	{
		Core::outputCompareTimerSound (value_ocr2);
	}
}

void SoundWrite::stop()
{
	__soundWritePlaying = false;
	__soundWritePlayingInfinite = false;
	__soundWritePlayingKey = false;
	_countAddKey = 0;
}
