void Random::seed (const unsigned char PIN)
{
	_byteAdmux = Core::pinToByteAdmux (PIN);
	Core::startAnalog();
}

bool Random::boolean()
{
	unsigned char search = 0;
	unsigned int valueAnalogPrevious = 0;
	unsigned int valueAnalogNext = 0;
	float artificialNoise = 1;
	
	for (search = 0; valueAnalogPrevious == valueAnalogNext && search < 3; search++)
	{
		valueAnalogPrevious = Core::readAnalog (_byteAdmux);
		valueAnalogNext = Core::readAnalog (_byteAdmux);
	}
	
	if (valueAnalogPrevious == valueAnalogNext)
	{
		artificialNoise = (artificialNoise + (float)(_seed)) * 0.9;
		valueAnalogPrevious = (unsigned int)(artificialNoise);
	}
	
	if (_seed < 4294967295)
	{
		_seed++;
	}
	else
	{
		_seed = 0;
	}
	
	return valueAnalogPrevious & 0b0000000000000001;
}

signed long Random::integer (const signed long MIN, const signed long MAX)
{
	unsigned long range = 0;
	unsigned char shift = 0;
	bool foundAccuracy = false;
	unsigned char search = 0;
	unsigned int valueAnalogPrevious = 0;
	unsigned int valueAnalogNext = 0;
	float artificialNoise = 1;
	unsigned long accuracy = 0;
	unsigned long valueRandom = 0;
	
	if (MIN <= MAX)
	{
		range = MAX - MIN;
	}
	else
	{
		range = MIN - MAX;
	}
	
	for (shift = 0; foundAccuracy == false; shift++)
	{
		for (search = 0; valueAnalogPrevious == valueAnalogNext && search < 3; search++)
		{
			valueAnalogPrevious = Core::readAnalog (_byteAdmux);
			valueAnalogNext = Core::readAnalog (_byteAdmux);
		}
		
		if (valueAnalogPrevious == valueAnalogNext)
		{
			artificialNoise = (artificialNoise + (float)(_seed)) * 0.9;
			valueAnalogPrevious = (unsigned int)(artificialNoise);
		}
		
		if (_seed < 4294967295)
		{
			_seed++;
		}
		else
		{
			_seed = 0;
		}
		
		valueRandom |= (unsigned long)(valueAnalogPrevious & 0b0000000000000001) << shift;
		accuracy |= (unsigned long)(0b00000000000000000000000000000001) << shift;
		
		valueAnalogPrevious = 0;
		valueAnalogNext = 0;
		
		if (accuracy >= range)
		{
			foundAccuracy = true;
		}
	}
	
	return Core::round (Core::curve (0, valueRandom, accuracy, MIN, MAX, 0));
}
