#include "Core.h"

class PwmWrite
{
	private:
	#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P || defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P
	static unsigned char _pin [2];
	#elif defined _ATMEGA1284P
	static unsigned char _pin [4];
	#endif
	volatile unsigned char *_registerTccr = 0;
	volatile unsigned int *_registerOcr = 0;
	unsigned char _byteCom = 0;
	static bool _hardware;
	static float _frequency;
	static unsigned int _valueIcr;
	unsigned char _channel = 0;
	#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
	static float _us [20];
	#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
	static float _us [32];
	#endif
	static bool _started;
	
	public:
	PwmWrite (const unsigned char PIN);
	static void start (const float FREQUENCY);
	void us (const float US);
	static void stop();
};

#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P || defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P
unsigned char PwmWrite::_pin [2] = {0, 0};
#elif defined _ATMEGA1284P
unsigned char PwmWrite::_pin [4] = {0, 0, 0, 0};
#endif
bool PwmWrite::_hardware = true;
float PwmWrite::_frequency = 0;
unsigned int PwmWrite::_valueIcr = 0;
#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
float PwmWrite::_us [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
float PwmWrite::_us [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif
bool PwmWrite::_started = false;

#include "PwmWrite.cpp"
