volatile unsigned char __pwmWriteCountChannel = 0;
volatile unsigned char __pwmWriteChannelCurrent = 0;
volatile unsigned char __pwmWriteChannelPrevious = 0;
#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
volatile unsigned char *__pwmWriteRegisterPort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmWriteBytePort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned int __pwmWriteValueOcr [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmWriteActiveChannel [20] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
volatile unsigned char *__pwmWriteRegisterPort [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmWriteBytePort [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned int __pwmWriteValueOcr [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmWriteActiveChannel [32] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
#endif

_INTERRUPT_JUMP (_TIMER1_OVF)
{
	if (__pwmWriteActiveChannel [__pwmWriteChannelCurrent] == true)
	{
		*__pwmWriteRegisterPort [__pwmWriteChannelCurrent] |= __pwmWriteBytePort [__pwmWriteChannelCurrent];
	}
	else
	{
		*__pwmWriteRegisterPort [__pwmWriteChannelCurrent] &= ~__pwmWriteBytePort [__pwmWriteChannelCurrent];
	}
	
	__pwmWriteChannelPrevious = __pwmWriteChannelCurrent;
	
	if (__pwmWriteChannelCurrent < __pwmWriteCountChannel - 1)
	{
		__pwmWriteChannelCurrent++;
	}
	else
	{
		__pwmWriteChannelCurrent = 0;
	}
	
	Core::outputCompareTimerPwm (__pwmWriteValueOcr [__pwmWriteChannelCurrent]);
}

_INTERRUPT_JUMP (_TIMER1_COMPA)
{
	*__pwmWriteRegisterPort [__pwmWriteChannelPrevious] &= ~__pwmWriteBytePort [__pwmWriteChannelPrevious];
}

PwmWrite::PwmWrite (const unsigned char PIN)
{
	if (Core::pinIsChannelTimerPwm (PIN) == false)
	{
		_hardware = false;
	}
	else if (_hardware == true)
	{
		_pin [__pwmWriteCountChannel] = PIN;
		_registerTccr = Core::pinToRegisterTccr (PIN);
		_registerOcr = Core::pinToRegisterOcr (PIN);
		_byteCom = Core::pinToByteCom (PIN);
	}
	
	__pwmWriteRegisterPort [__pwmWriteCountChannel] = Core::pinToRegisterPort (PIN);
	__pwmWriteBytePort [__pwmWriteCountChannel] = Core::pinToBytePort (PIN);
	
	*Core::pinToRegisterDdr (PIN) |= __pwmWriteBytePort [__pwmWriteCountChannel];
	
	_channel = __pwmWriteCountChannel;
	
	__pwmWriteCountChannel++;
}

void PwmWrite::start (const float FREQUENCY)
{
	unsigned char iterationChannel = 0;
	unsigned int prescaler = 0;
	unsigned int valueOcr = 0;
	
	Core::startGlobalInterrupt();
	Core::modeTimerPwm();
	
	if (_hardware == false)
	{
		prescaler = Core::frequencyToPrescalerTimerPwm (FREQUENCY * (float)(__pwmWriteCountChannel));
		
		Core::prescalerTimerPwm (prescaler);
		
		_frequency = FREQUENCY * (float)(__pwmWriteCountChannel);
		_valueIcr = Core::round (((16000000.0 / (float)(prescaler)) / (FREQUENCY * (float)(__pwmWriteCountChannel))) - 1.0);
		
		for (iterationChannel = 0; iterationChannel < __pwmWriteCountChannel; iterationChannel++)
		{
			valueOcr = Core::round ((float)(_valueIcr) - ((float)(_valueIcr) - ((float)(_valueIcr) / ((1000000.0 / _us [iterationChannel]) / _frequency))));
			__pwmWriteValueOcr [iterationChannel] = valueOcr;
			
			if (valueOcr != 0)
			{
				__pwmWriteActiveChannel [iterationChannel] = true;
			}
			else
			{
				__pwmWriteActiveChannel [iterationChannel] = false;
			}
		}
		
		Core::inputCaptureTimerPwm (_valueIcr);
		Core::startInterruptTimerPwm();
	}
	else
	{
		prescaler = Core::frequencyToPrescalerTimerPwm (FREQUENCY);
		
		Core::prescalerTimerPwm (prescaler);
		
		_frequency = FREQUENCY;
		_valueIcr = Core::round (((16000000.0 / (float)(prescaler)) / FREQUENCY) - 1.0);
		
		Core::inputCaptureTimerPwm (_valueIcr);
		
		for (iterationChannel = 0; iterationChannel < __pwmWriteCountChannel; iterationChannel++)
		{
			valueOcr = Core::round ((float)(_valueIcr) - ((float)(_valueIcr) - ((float)(_valueIcr) / ((1000000.0 / _us [iterationChannel]) / _frequency))));
			
			if (valueOcr != 0)
			{
				*Core::pinToRegisterOcr (_pin [iterationChannel]) = valueOcr;
				*Core::pinToRegisterTccr (_pin [iterationChannel]) |= Core::pinToByteCom (_pin [iterationChannel]);
			}
			else
			{
				*Core::pinToRegisterTccr (_pin [iterationChannel]) &= ~Core::pinToByteCom (_pin [iterationChannel]);
			}
		}
	}
	
	_started = true;
}

void PwmWrite::us (const float US)
{
	const unsigned int VALUE_OCR = Core::round ((float)(_valueIcr) - ((float)(_valueIcr) - ((float)(_valueIcr) / ((1000000.0 / US) / _frequency))));
	
	_us [_channel] = US;
	
	if (_started == true)
	{
		if (_hardware == false)
		{
			__pwmWriteValueOcr [_channel] = VALUE_OCR;
			
			if (VALUE_OCR != 0)
			{
				__pwmWriteActiveChannel [_channel] = true;
			}
			else
			{
				__pwmWriteActiveChannel [_channel] = false;
			}
		}
		else
		{
			if (VALUE_OCR != 0)
			{
				*_registerOcr = VALUE_OCR;
				*_registerTccr |= _byteCom;
			}
			else
			{
				*_registerTccr &= ~_byteCom;
			}
		}
	}
}

void PwmWrite::stop()
{
	unsigned char iterationChannel = 0;
	
	if (_started == true)
	{
		if (_hardware == false)
		{
			Core::stopInterruptTimerPwm();
			
			for (iterationChannel = 0; iterationChannel < __pwmWriteCountChannel; iterationChannel++)
			{
				*__pwmWriteRegisterPort [iterationChannel] &= ~__pwmWriteBytePort [iterationChannel];
			}
			
			__pwmWriteChannelCurrent = 0;
			__pwmWriteChannelPrevious = 0;
		}
		else
		{
			for (iterationChannel = 0; iterationChannel < __pwmWriteCountChannel; iterationChannel++)
			{
				*Core::pinToRegisterTccr (_pin [iterationChannel]) &= ~Core::pinToByteCom (_pin [iterationChannel]);
			}
		}
		
		_started = false;
	}
}
