volatile unsigned char __pwmReadCountChannel = 0;
volatile unsigned char __pwmReadIterationChannel = 0;
#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
volatile bool __pwmReadCheck [20] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile unsigned char *__pwmReadRegisterPin [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePort [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char *__pwmReadRegisterPcmsk [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePcie [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmReadRising [20] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
volatile bool __pwmReadCheck [32] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
volatile unsigned char *__pwmReadRegisterPin [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePort [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char *__pwmReadRegisterPcmsk [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile unsigned char __pwmReadBytePcie [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
volatile bool __pwmReadRising [32] = {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
#endif
volatile bool __pwmReadFirstFront = false;
volatile unsigned long long __pwmReadTimePrevious = 0;
#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
volatile unsigned long __pwmReadUs [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
volatile unsigned long __pwmReadUs [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif
volatile bool __pwmReadValuePin = false;

_INTERRUPT_JUMP (_PCINT0)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadIterationChannel] & __pwmReadBytePort [__pwmReadIterationChannel];
	
	if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = 0b00000000;
		
		__pwmReadUs [__pwmReadIterationChannel] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadIterationChannel] = true;
		
		if (__pwmReadIterationChannel < __pwmReadCountChannel - 1)
		{
			__pwmReadIterationChannel++;
		}
		else
		{
			__pwmReadIterationChannel = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = __pwmReadBytePort [__pwmReadIterationChannel];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadIterationChannel]);
	}
}

_INTERRUPT_JUMP (_PCINT1)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadIterationChannel] & __pwmReadBytePort [__pwmReadIterationChannel];
	
	if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = 0b00000000;
		
		__pwmReadUs [__pwmReadIterationChannel] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadIterationChannel] = true;
		
		if (__pwmReadIterationChannel < __pwmReadCountChannel - 1)
		{
			__pwmReadIterationChannel++;
		}
		else
		{
			__pwmReadIterationChannel = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = __pwmReadBytePort [__pwmReadIterationChannel];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadIterationChannel]);
	}
}

_INTERRUPT_JUMP (_PCINT2)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadIterationChannel] & __pwmReadBytePort [__pwmReadIterationChannel];
	
	if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = 0b00000000;
		
		__pwmReadUs [__pwmReadIterationChannel] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadIterationChannel] = true;
		
		if (__pwmReadIterationChannel < __pwmReadCountChannel - 1)
		{
			__pwmReadIterationChannel++;
		}
		else
		{
			__pwmReadIterationChannel = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = __pwmReadBytePort [__pwmReadIterationChannel];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadIterationChannel]);
	}
}

#if defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
_INTERRUPT_JUMP (_PCINT3)
{
	__pwmReadValuePin = *__pwmReadRegisterPin [__pwmReadIterationChannel] & __pwmReadBytePort [__pwmReadIterationChannel];
	
	if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == true) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == false)) && __pwmReadFirstFront == false)
	{
		__pwmReadTimePrevious = Core::us();
		__pwmReadFirstFront = true;
	}
	else if (((__pwmReadRising [__pwmReadIterationChannel] == true && __pwmReadValuePin == false) || (__pwmReadRising [__pwmReadIterationChannel] == false && __pwmReadValuePin == true)) && __pwmReadFirstFront == true)
	{
		Core::stopPinChangeInterrupt();
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = 0b00000000;
		
		__pwmReadUs [__pwmReadIterationChannel] = Core::us() - __pwmReadTimePrevious;
		__pwmReadFirstFront = false;
		__pwmReadCheck [__pwmReadIterationChannel] = true;
		
		if (__pwmReadIterationChannel < __pwmReadCountChannel - 1)
		{
			__pwmReadIterationChannel++;
		}
		else
		{
			__pwmReadIterationChannel = 0;
		}
		
		*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = __pwmReadBytePort [__pwmReadIterationChannel];
		Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadIterationChannel]);
	}
}
#endif

PwmRead::PwmRead (const unsigned char PIN, const bool RISING)
{
	__pwmReadRegisterPin [__pwmReadCountChannel] = Core::pinToRegisterPin (PIN);
	__pwmReadBytePort [__pwmReadCountChannel] = Core::pinToBytePort (PIN);
	__pwmReadRegisterPcmsk [__pwmReadCountChannel] = Core::pinToRegisterPcmsk (PIN);
	__pwmReadBytePcie [__pwmReadCountChannel] = Core::pinToBytePcie (PIN);
	__pwmReadRising [__pwmReadCountChannel] = RISING;
	
	_iterationChannel = __pwmReadCountChannel;
	
	__pwmReadCountChannel++;
}

void PwmRead::start()
{
	Core::startGlobalInterrupt();
	Core::startInterruptTimerCounter();
	
	*__pwmReadRegisterPcmsk [0] = __pwmReadBytePort [0];
	Core::startPinChangeInterrupt (__pwmReadBytePcie [0]);
}

void PwmRead::read()
{
	const unsigned long long MS = Core::ms();
	
	if (_started == true)
	{
		if (__pwmReadIterationChannel == _iterationChannel)
		{
			if (__pwmReadCheck [_iterationChannel] == false)
			{
				if (_firstRead == true && MS >= _timePrevious)
				{
					Core::stopPinChangeInterrupt();
					*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = 0b00000000;
					
					if (__pwmReadIterationChannel < __pwmReadCountChannel - 1)
					{
						__pwmReadIterationChannel++;
					}
					else
					{
						__pwmReadIterationChannel = 0;
					}
					
					__pwmReadFirstFront = false;
					
					*__pwmReadRegisterPcmsk [__pwmReadIterationChannel] = __pwmReadBytePort [__pwmReadIterationChannel];
					Core::startPinChangeInterrupt (__pwmReadBytePcie [__pwmReadIterationChannel]);
					
					_firstRead = false;
				}
				else if (_firstRead == false)
				{
					_timePrevious = MS + 100ull;
					_firstRead = true;
				}
			}
			else
			{
				__pwmReadCheck [_iterationChannel] = false;
				_firstRead = false;
			}
		}
		
		us = __pwmReadUs [_iterationChannel];
	}
}

void PwmRead::stop()
{
	unsigned char iterationChannel = 0;
	
	if (_started == true)
	{
		Core::stopPinChangeInterrupt();
		
		for (iterationChannel = 0; iterationChannel < __pwmReadCountChannel; iterationChannel++)
		{
			*__pwmReadRegisterPcmsk [iterationChannel] = 0b00000000;
			__pwmReadCheck [iterationChannel] = false;
		}
		
		__pwmReadFirstFront = false;
		__pwmReadIterationChannel = 0;
		
		_firstRead = false;
		_started = false;
	}
}
