Iteration::Iteration (const signed long MIN, const signed long START, const signed long MAX, const bool LOOP)
{
	_min = MIN;
	_start = START;
	_max = MAX;
	_loop = LOOP;
	
	if ((MIN < MAX && START <= MIN) || (MIN > MAX && START >= MIN))
	{
		value = MIN;
	}
	else if ((MIN < MAX && START >= MAX) || (MIN > MAX && START <= MAX))
	{
		value = MAX;
	}
	else
	{
		value = START;
	}
}

void Iteration::increment (const signed long INCREMENT)
{
	signed long increment = 0;
	
	if (_min < _max)
	{
		increment = INCREMENT % ((_max - _min) + 1l);
	}
	else if (_min > _max)
	{
		increment = INCREMENT % ((_min - _max) + 1l);
	}
	
	if (increment > 0)
	{
		if (_loop == false)
		{
			if (_max > _min)
			{
				if (value + increment < _max)
				{
					value += increment;
				}
				else
				{
					value = _max;
				}
			}
			else
			{
				if (value + increment < _min)
				{
					value += increment;
				}
				else
				{
					value = _min;
				}
			}
		}
		else
		{
			if (_max > _min)
			{
				if (value + increment < _max)
				{
					value += increment;
				}
				else if (value + increment == _max)
				{
					value = _max;
				}
				else
				{
					value = ((value + increment) - (_max - _min)) - 1l;
				}
			}
			else
			{
				if (value + increment < _min)
				{
					value += increment;
				}
				else if (value + increment == _min)
				{
					value = _min;
				}
				else
				{
					value = ((value + increment) - (_min - _max)) - 1l;
				}
			}
		}
	}
	else if (increment < 0)
	{
		if (_loop == false)
		{
			if (_max > _min)
			{
				if (value + increment > _min)
				{
					value += increment;
				}
				else
				{
					value = _min;
				}
			}
			else
			{
				if (value + increment > _max)
				{
					value += increment;
				}
				else
				{
					value = _max;
				}
			}
		}
		else
		{
			if (_max > _min)
			{
				if (value + increment > _min)
				{
					value += increment;
				}
				else if (value + increment == _min)
				{
					value = _min;
				}
				else
				{
					value = ((value + increment) + (_max - _min)) + 1l;
				}
			}
			else
			{
				if (value + increment > _max)
				{
					value += increment;
				}
				else if (value + increment == _max)
				{
					value = _max;
				}
				else
				{
					value = ((value + increment) + (_min - _max)) + 1l;
				}
			}
		}
	}
}

void Iteration::min (const signed long MIN)
{
	_min = MIN;
	
	if ((MIN < _max && value <= MIN) || (MIN > _max && value >= MIN))
	{
		value = MIN;
	}
	else if ((MIN < _max && value >= _max) || (MIN > _max && value <= _max))
	{
		value = _max;
	}
}

void Iteration::set (const signed long VALUE)
{
	if ((_min < _max && VALUE <= _min) || (_min > _max && VALUE >= _min))
	{
		value = _min;
	}
	else if ((_min < _max && VALUE >= _max) || (_min > _max && VALUE <= _max))
	{
		value = _max;
	}
	else
	{
		value = VALUE;
	}
}

void Iteration::max (const signed long MAX)
{
	_max = MAX;
	
	if ((_min < MAX && value <= _min) || (_min > MAX && value >= _min))
	{
		value = _min;
	}
	else if ((_min < MAX && value >= MAX) || (_min > MAX && value <= MAX))
	{
		value = MAX;
	}
}

void Iteration::loop (const bool LOOP)
{
	_loop = LOOP;
}

void Iteration::reset()
{
	if ((_min < _max && _start <= _min) || (_min > _max && _start >= _min))
	{
		value = _min;
	}
	else if ((_min < _max && _start >= _max) || (_min > _max && _start <= _max))
	{
		value = _max;
	}
	else
	{
		value = _start;
	}
}
