typedef void (*__interruptReadFunction)();

#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
volatile __interruptReadFunction __interruptReadFunctionJump [2] = {0, 0};
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
volatile __interruptReadFunction __interruptReadFunctionJump [3] = {0, 0, 0};
#endif

_INTERRUPT_JUMP (_INT0)
{
	__interruptReadFunctionJump [0]();
}

_INTERRUPT_JUMP (_INT1)
{
	__interruptReadFunctionJump [1]();
}

#if defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
_INTERRUPT_JUMP (_INT2)
{
	__interruptReadFunctionJump [2]();
}
#endif

InterruptRead::InterruptRead (const unsigned char PIN)
{
	_interrupt = Core::pinToInterrupt (PIN);
}

void InterruptRead::start (void functionJump(), const bool RISING, const bool FALLING)
{
	if (_interrupt != 255)
	{
		__interruptReadFunctionJump [_interrupt] = functionJump;
		
		Core::startGlobalInterrupt();
		Core::startInterrupt (_interrupt, RISING, FALLING);
	}
}

void InterruptRead::stop()
{
	if (_interrupt != 255)
	{
		Core::stopInterrupt (_interrupt);
		__interruptReadFunctionJump [_interrupt] = 0;
	}
}
