GpioWrite::GpioWrite (const unsigned char PIN)
{
	_registerPort = Core::pinToRegisterPort (PIN);
	_registerPin = Core::pinToRegisterPin (PIN);
	_bytePort = Core::pinToBytePort (PIN);
	
	*Core::pinToRegisterDdr (PIN) |= _bytePort;
}

void GpioWrite::toggle()
{
	*_registerPin = _bytePort;
}

void GpioWrite::on()
{
	*_registerPort |= _bytePort;
}

void GpioWrite::off()
{
	*_registerPort &= ~_bytePort;
}
