GpioRead::GpioRead (const unsigned char PIN, const bool PULL_UP_INTERNAL, const unsigned char DEBOUNCING)
{
	_registerPin = Core::pinToRegisterPin (PIN);
	_bytePort = Core::pinToBytePort (PIN);
	
	if (PULL_UP_INTERNAL == true)
	{
		*_registerPin = _bytePort;
		_pullUpInternal = true;
	}
	
	if (DEBOUNCING != 0)
	{
		_debouncing = DEBOUNCING;
		
		Core::startGlobalInterrupt();
		Core::startInterruptTimerCounter();
	}
}

void GpioRead::read()
{
	const unsigned long long MS = Core::ms();
	const bool VALUE_PIN = *_registerPin & _bytePort;
	
	if (((VALUE_PIN == true && _pullUpInternal == false) || (VALUE_PIN == false && _pullUpInternal == true)) && bistable == false)
	{
		if (_debouncing == 0)
		{
			bistable = true;
		}
		else if (MS >= _timePreviousBistable)
		{
			_timePreviousBistable = MS + (unsigned long long)(_debouncing);
			bistable = true;
		}
	}
	else if (((VALUE_PIN == false && _pullUpInternal == false) || (VALUE_PIN == true && _pullUpInternal == true)) && bistable == true)
	{
		if (_debouncing == 0)
		{
			bistable = false;
		}
		else if (MS >= _timePreviousBistable)
		{
			_timePreviousBistable = MS + (unsigned long long)(_debouncing);
			bistable = false;
		}
	}
	
	if (((VALUE_PIN == true && _pullUpInternal == false) || (VALUE_PIN == false && _pullUpInternal == true)) && _lockMonostable == false)
	{
		monostable = true;
		_lockMonostable = true;
	}
	else if (monostable == true && _lockMonostable == true)
	{
		_timePreviousMonostable = MS + (unsigned long long)(_debouncing);
		monostable = false;
	}
	else if (((VALUE_PIN == false && _pullUpInternal == false) || (VALUE_PIN == true && _pullUpInternal == true)) && _lockMonostable == true)
	{
		if (_debouncing == 0)
		{
			_lockMonostable = false;
		}
		else if (MS >= _timePreviousMonostable)
		{
			_lockMonostable = false;
		}
	}
}
