Filter::Filter (const unsigned long AMOUNT, const bool TIME_COMPENSATION)
{
	_amount = AMOUNT;
	_timeCompensation = TIME_COMPENSATION;
	
	if (TIME_COMPENSATION == true)
	{
		Core::startGlobalInterrupt();
		Core::startInterruptTimerCounter();
	}
}

void Filter::set (const float VALUE)
{
	const unsigned long long US = Core::us();
	
	if (_firstSet == false || (_amount <= 1 && _timeCompensation == false) || (_amount == 0 && _timeCompensation == true))
	{
		value = VALUE;
		_firstSet = true;
	}
	else
	{
		if (_timeCompensation == false)
		{
			value = (VALUE / (float)(_amount)) + (value - (value / (float)(_amount)));
		}
		else
		{
			if (US - _timePrevious < _amount * 1000ul)
			{
				value = (VALUE * (((float)(US) - (float)(_timePrevious)) / ((float)(_amount) * 1000.0))) + (value - (value * (((float)(US) - (float)(_timePrevious)) / ((float)(_amount) * 1000.0))));
			}
			else
			{
				value = VALUE;
			}
		}
	}
	
	_timePrevious = US;
}

void Filter::amount (const unsigned long AMOUNT)
{
	_amount = AMOUNT;
}

void Filter::reset()
{
	_firstSet = false;
}
