signed long Eeprom::read (const unsigned int ADDRESS, const signed char LENGTH)
{
	unsigned char iterationAddress = 0;
	unsigned char shift = 0;
	signed long data = 0;
	
	if (LENGTH < 0)
	{
		for (shift = -LENGTH; shift != 0; shift -= 8)
		{
			if (LENGTH == -8)
			{
				data |= (signed char)(Core::readEeprom ((ADDRESS + iterationAddress) - 1)) << (shift - 8);
			}
			else if (LENGTH == -16)
			{
				data |= (signed int)(Core::readEeprom ((ADDRESS + iterationAddress) - 1)) << (shift - 8);
			}
			else if (LENGTH == -32)
			{
				data |= (signed long)(Core::readEeprom ((ADDRESS + iterationAddress) - 1)) << (shift - 8);
			}
			
			iterationAddress++;
		}
	}
	else
	{
		for (shift = LENGTH; shift != 0; shift -= 8)
		{
			if (LENGTH == 8)
			{
				data |= (unsigned char)(Core::readEeprom ((ADDRESS + iterationAddress) - 1)) << (shift - 8);
			}
			else if (LENGTH == 16)
			{
				data |= (unsigned int)(Core::readEeprom ((ADDRESS + iterationAddress) - 1)) << (shift - 8);
			}
			else if (LENGTH == 32)
			{
				data |= (unsigned long)(Core::readEeprom ((ADDRESS + iterationAddress) - 1)) << (shift - 8);
			}
			
			iterationAddress++;
		}
	}
	
	return data;
}

void Eeprom::write (const unsigned int ADDRESS, const signed long DATA, const signed char LENGTH)
{
	unsigned char iterationAddress = 0;
	unsigned char shift = 0;
	
	if (LENGTH < 0)
	{
		for (shift = -LENGTH; shift != 0; shift -= 8)
		{
			if (Core::readEeprom ((ADDRESS + iterationAddress) - 1) != DATA >> (shift - 8))
			{
				Core::writeEeprom ((ADDRESS + iterationAddress) - 1, DATA >> (shift - 8));
			}
			
			iterationAddress++;
		}
	}
	else
	{
		for (shift = LENGTH; shift != 0; shift -= 8)
		{
			if (Core::readEeprom ((ADDRESS + iterationAddress) - 1) != DATA >> (shift - 8))
			{
				Core::writeEeprom ((ADDRESS + iterationAddress) - 1, DATA >> (shift - 8));
			}
			
			iterationAddress++;
		}
	}
}

void Eeprom::erase()
{
	unsigned int iterationAddress = 0;
	
	#if defined _ATMEGA48P
	for (iterationAddress = 0; iterationAddress < 256; iterationAddress++)
	#elif defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA164P
	for (iterationAddress = 0; iterationAddress < 512; iterationAddress++)
	#elif defined _ATMEGA328P || defined _ATMEGA324P
	for (iterationAddress = 0; iterationAddress < 1024; iterationAddress++)
	#elif defined _ATMEGA644P
	for (iterationAddress = 0; iterationAddress < 2048; iterationAddress++)
	#elif defined _ATMEGA1284P
	for (iterationAddress = 0; iterationAddress < 4096; iterationAddress++)
	#endif
	{
		if (Core::readEeprom (iterationAddress) != 0)
		{
			Core::writeEeprom (iterationAddress, 0);
		}
	}
}
