Delay::Delay (const unsigned long long DURATION, const bool NO_START_DELAY)
{
	_duration = DURATION;
	_noStartDelay = NO_START_DELAY;
	
	Core::startGlobalInterrupt();
	Core::startInterruptTimerCounter();
}

void Delay::state()
{
	const unsigned long long MS = Core::ms();
	
	if (_started == false)
	{
		_timePrevious = MS;
		_timeNext = MS + _duration;
		
		if (_duration == 0 || _noStartDelay == true)
		{
			update = true;
		}
		else
		{
			update = false;
		}
		
		_started = true;
	}
	else if (MS >= _timeNext)
	{
		_timePrevious = MS;
		_timeNext = MS + _duration;
		
		update = true;
	}
	else
	{
		update = false;
	}
}

void Delay::duration (const unsigned long long DURATION)
{
	_duration = DURATION;
	_timeNext = _timePrevious + DURATION;
}

void Delay::reset()
{
	_started = false;
}
