#ifndef _CORE_INCLUDED
#define _CORE_INCLUDED

#include "Define.h"

class Core
{
	private:
	#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
	static unsigned char _countSpiDevice [20];
	#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
	static unsigned char _countSpiDevice [32];
	#endif
	
	public:
	static void startGlobalInterrupt();
	static unsigned long long s();
	static unsigned long long ms();
	static unsigned long long us();
	static volatile unsigned char *pinToRegisterPort (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterDdr (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterPin (const unsigned char PIN);
	static unsigned char pinToBytePort (const unsigned char PIN);
	static unsigned char pinToInterrupt (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterPcmsk (const unsigned char PIN);
	static unsigned char pinToBytePcie (const unsigned char PIN);
	static bool pinIsChannelTimerPwm (const unsigned char PIN);
	static volatile unsigned char *pinToRegisterTccr (const unsigned char PIN);
	static volatile unsigned int *pinToRegisterOcr (const unsigned char PIN);
	static unsigned char pinToByteCom (const unsigned char PIN);
	static unsigned char pinToByteAdmux (const unsigned char PIN);
	static void startInterruptTimerCounter();
	static void modeTimerPwm();
	static unsigned int frequencyToPrescalerTimerPwm (const float FREQUENCY);
	static void prescalerTimerPwm (const unsigned int PRESCALER);
	static void inputCaptureTimerPwm (const unsigned int VALUE);
	static void outputCompareTimerPwm (const unsigned int VALUE);
	static void startInterruptTimerPwm();
	static void stopInterruptTimerPwm();
	static void modeTimerSound();
	static unsigned int frequencyToPrescalerTimerSound (const float FREQUENCY);
	static void prescalerTimerSound (const unsigned int PRESCALER);
	static void outputCompareTimerSound (const unsigned char VALUE);
	static void startInterruptTimerSound();
	static void stopInterruptTimerSound();
	static void startInterrupt (const unsigned char INTERRUPT, const bool RISING, const bool FALLING);
	static void stopInterrupt (const unsigned char INTERRUPT);
	static void startPinChangeInterrupt (const unsigned char BYTE_PCIE);
	static void stopPinChangeInterrupt();
	static unsigned char digitToByte (const unsigned char DIGIT, const bool COMMA);
	static unsigned char characterToByte (const char CHARACTER);
	static void startSpi();
	static unsigned char deviceSpi (const unsigned char PIN_SS);
	static signed long readSpi (const unsigned char ADDRESS, const signed char LENGTH);
	static signed long readSpiPush (const signed char LENGTH);
	static void writeSpi (const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void writeSpiPush (const signed long DATA, const signed char LENGTH);
	static void writeSpiCascaded (const unsigned char PIN_SS, const unsigned char DEVICE, const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void startUsart (const unsigned long FREQUENCY);
	static signed long readUsart (const signed char LENGTH);
	static void writeUsart (const signed long DATA, const signed char LENGTH);
	static void stopUsart();
	static void startTwi();
	static bool scanTwi (const unsigned char DEVICE);
	static signed long readTwi (const unsigned char DEVICE, const unsigned char ADDRESS, const signed char LENGTH);
	static void writeTwi (const unsigned char DEVICE, const unsigned char ADDRESS, const signed long DATA, const signed char LENGTH);
	static void startAnalog();
	static unsigned int readAnalog (const unsigned char BYTE_ADMUX);
	#if defined _ATMEGA48P
	static unsigned char readEeprom (const unsigned char ADDRESS);
	static void writeEeprom (const unsigned char ADDRESS, const unsigned char DATA);
	#elif defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P || defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
	static unsigned char readEeprom (const unsigned int ADDRESS);
	static void writeEeprom (const unsigned int ADDRESS, const unsigned char DATA);
	#endif
	static unsigned long crc32 (const signed long DATA);
	static void power (const bool POWER);
	static signed long floor (const float VALUE);
	static signed long round (const float VALUE);
	static signed long ceil (const float VALUE);
	static float curve (const float POSITION_START, const float POSITION_CURRENT, const float POSITION_END, const float INTERPOLATION_START, const float INTERPOLATION_END, const float CURVE);
	static float wurve (const float POSITION_START, const float POSITION_CURRENT, const float POSITION_END, const float INTERPOLATION_START, const float INTERPOLATION_CENTER, const float INTERPOLATION_END, const float CURVE_START, const float CURVE_END);
	static float range (const float RANGE_START, const float VALUE_CURRENT, const float RANGE_END);
	static float center (const float VALUE_START, const float VALUE_END);
	static float pow (const float NUMBER, const signed long EXPONENT);
	static float sqrt (const float RADICAND);
	static unsigned long long fact (const unsigned long INTEGER);
	static float sin (const float ANGLE);
	static float cos (const float ANGLE);
	static float tan (const float ANGLE);
	static float arcsin (const float SINUS);
	static float arccos (const float COSINUS);
	static float arctan (const float TANGENT);
	static float arctan2 (const float X, const float Y);
};

#if defined _ATMEGA48P || defined _ATMEGA88P || defined _ATMEGA168P || defined _ATMEGA328P
unsigned char Core::_countSpiDevice [20] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#elif defined _ATMEGA164P || defined _ATMEGA324P || defined _ATMEGA644P || defined _ATMEGA1284P
unsigned char Core::_countSpiDevice [32] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
#endif

#include "Core.cpp"
#endif
